<?php
/**
 * @version     $Id$ 2.0.0 0
 * @package     Joomla
 * @copyright   Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license     GNU/GPL, see LICENSE.php
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// define the control_panel model class of aiContactSafe
class AiContactSafeModelMessages extends AiContactSafeModelDefault {

	// function to add/modify values in the record list
	function setRowValues($rowlist) {
		$n = count($rowlist);
		for ($i = 0; $i < $n; $i++ ) {
			$rowlist[$i]->view = JRoute::_('index.php?option=com_aicontactsafe&sTask=' . $this->_sTask . '&task=view&id=' . $rowlist[$i]->id);
		}
	}

	// function to define the sql command to select records to delete
	function setDeleteSelect() {
		$field_separator = '&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;';
		$this->delete_select_sql = 'SELECT id, CONCAT(TRIM(name),\''.$field_separator.'\',TRIM(email),\''.$field_separator.'\',TRIM(subject),\''.$field_separator.'\',date_added) as name FROM #__aicontactsafe_messages %where% order by name';
		return $this->delete_select_sql;
	}

	// function to delete selected records
	function deleteData() {
		$wasDeleted = parent::deleteData();
		// initialize different variables
		if ($wasDeleted) {
			// initialize the database
			$db = &JFactory::getDBO();
			// import joomla clases to manage file system
			jimport('joomla.filesystem.path');
			jimport('joomla.filesystem.file');
			// get the path to attachments upload
			$upload_folder = str_replace('\\',DS,$this->_config_values['upload_attachments']);
			$upload_folder = str_replace('/',DS,$upload_folder);
			$upload_folder = str_replace('&#92;',DS,$upload_folder);
			$path_upload = JPATH_ROOT.DS.$upload_folder;
			// read the ids of the records seleted for deletion
			$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
			JArrayHelper::toInteger($cid);
			if (count($cid) > 0) {
				$cids = implode(',', $cid);
			} else {
				$cids = '-1';
			}
			// get the files to delete
			$query = 'SELECT id, name FROM #__aicontactsafe_messagefiles WHERE message_id IN ( '.$cids.' )';
			$db->setQuery($query);
			$files = $db->loadObjectList();
			if (count($files) > 0) {
				foreach($files as $file) {
					$delete_file = $path_upload.DS.$file->name;
					JFile::delete($delete_file);
					$query = 'DELETE FROM #__aicontactsafe_messagefiles WHERE id = '.$file->id;
					$db->setQuery($query);
					$db->query();
				}
			}
		}
		return true;
	}

}
?>
